<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\ResourceModel\Rule\Relation\Segment;

use Amasty\Followup\Api\Data\RuleInterface;
use Amasty\Followup\Model\ResourceModel\Rule;
use Amasty\Followup\Model\ResourceModel\Rule\Relation\HandlerInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\DB\Adapter\AdapterInterface;

class SaveHandler implements HandlerInterface
{
    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    /**
     * @var string
     */
    private $ruleSegmentTable;

    public function __construct(
        ResourceConnection $resourceConnection
    ) {
        $this->resourceConnection = $resourceConnection;
        $this->ruleSegmentTable = $this->resourceConnection->getTableName(Rule::RULE_SEGMENT_TABLE);
    }

    public function execute(RuleInterface $entity, array $arguments = []): RuleInterface
    {
        $entityId = $entity->getRuleId();
        if (!$entityId) {
            return $entity;
        }

        $this->deleteByEntity($entityId);
        $segmentIdsToInsert = $this->getSegmentIds($entity);
        $this->insertSegmentData($segmentIdsToInsert);

        return $entity;
    }

    private function getConnection(): AdapterInterface
    {
        return $this->resourceConnection->getConnection();
    }

    private function deleteByEntity(int $ruleId): void
    {
        $this->getConnection()->delete($this->ruleSegmentTable, [RuleInterface::RULE_ID . ' = ?' => $ruleId]);
    }

    private function getSegmentIds(RuleInterface $entity): array
    {
        $ruleSegmentIds = [];

        if ($segmentIds = $entity->getSegmentIds()) {
            foreach ($segmentIds as $segmentId) {
                $ruleSegmentIds[] = [
                    'rule_id' => $entity->getRuleId(),
                    'segment_id' => $segmentId
                ];
            }
        }

        return $ruleSegmentIds;
    }

    private function insertSegmentData(array $segmentIdsToInsert)
    {
        if (!empty($segmentIdsToInsert)) {
            $this->getConnection()->insertMultiple($this->ruleSegmentTable, $segmentIdsToInsert);
        }

        return $this;
    }
}
