<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\ResourceModel\Rule\Relation\Segment;

use Amasty\Followup\Api\Data\RuleInterface;
use Amasty\Followup\Model\ResourceModel\Rule;
use Amasty\Followup\Model\ResourceModel\Rule\Relation\HandlerInterface;
use Magento\Framework\App\ResourceConnection;

class ReadHandler implements HandlerInterface
{
    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    /**
     * @var string
     */
    private $ruleSegmentTable;

    public function __construct(
        ResourceConnection $resourceConnection
    ) {
        $this->resourceConnection = $resourceConnection;
        $this->ruleSegmentTable = $this->resourceConnection->getTableName(Rule::RULE_SEGMENT_TABLE);
    }

    public function execute(RuleInterface $entity, array $arguments = []): RuleInterface
    {
        $entityId = $entity->getRuleId();
        if (!$entityId) {
            return $entity;
        }

        $segments = $this->loadSegmentIds($entityId);
        $entity->setSegmentIds($segments);

        return $entity;
    }

    private function loadSegmentIds(int $entityId): array
    {
        $connection = $this->resourceConnection->getConnection();
        $select = $connection->select()
            ->from($this->ruleSegmentTable, ['segment_id'])
            ->where('rule_id = ?', $entityId);

        return $connection->fetchCol($select);
    }
}
