<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\ResourceModel\Rule\Relation\CustomerGroup;

use Amasty\Followup\Api\Data\RuleInterface;
use Amasty\Followup\Model\ResourceModel\Rule;
use Amasty\Followup\Model\ResourceModel\Rule\Relation\HandlerInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\DB\Adapter\AdapterInterface;

class SaveHandler implements HandlerInterface
{
    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    /**
     * @var string
     */
    private $ruleCustomerGroupTable;

    public function __construct(
        ResourceConnection $resourceConnection
    ) {
        $this->resourceConnection = $resourceConnection;
        $this->ruleCustomerGroupTable = $this->resourceConnection->getTableName(Rule::RULE_CUSTOMER_GROUP_TABLE);
    }

    public function execute(RuleInterface $entity, array $arguments = []): RuleInterface
    {
        $entityId = $entity->getRuleId();
        if (!$entityId) {
            return $entity;
        }

        $this->deleteByEntity($entityId);
        $groupIdsToInsert = $this->getGroupIds($entity);
        $this->insertGroupData($groupIdsToInsert);

        return $entity;
    }

    private function getConnection(): AdapterInterface
    {
        return $this->resourceConnection->getConnection();
    }

    private function deleteByEntity(int $ruleId): void
    {
        $this->getConnection()->delete($this->ruleCustomerGroupTable, [RuleInterface::RULE_ID . ' = ?' => $ruleId]);
    }

    private function getGroupIds(RuleInterface $entity): array
    {
        $ruleGroupIds = [];

        if ($groupIds = $entity->getCustomerGroupIds()) {
            foreach ($groupIds as $groupId) {
                $ruleGroupIds[] = [
                    'rule_id' => $entity->getRuleId(),
                    'customer_group_id' => $groupId
                ];
            }
        }

        return $ruleGroupIds;
    }

    private function insertGroupData(array $groupIdsToInsert)
    {
        if (!empty($groupIdsToInsert)) {
            $this->getConnection()->insertMultiple($this->ruleCustomerGroupTable, $groupIdsToInsert);
        }

        return $this;
    }
}
