<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\ResourceModel\Rule\Relation\CustomerGroup;

use Amasty\Followup\Api\Data\RuleInterface;
use Amasty\Followup\Model\ResourceModel\Rule;
use Amasty\Followup\Model\ResourceModel\Rule\Relation\HandlerInterface;
use Magento\Framework\App\ResourceConnection;

class ReadHandler implements HandlerInterface
{
    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    /**
     * @var string
     */
    private $ruleCustomerGroupTable;

    public function __construct(
        ResourceConnection $resourceConnection
    ) {
        $this->resourceConnection = $resourceConnection;
        $this->ruleCustomerGroupTable = $this->resourceConnection->getTableName(Rule::RULE_CUSTOMER_GROUP_TABLE);
    }

    public function execute(RuleInterface $entity, array $arguments = []): RuleInterface
    {
        $entityId = $entity->getRuleId();
        if (!$entityId) {
            return $entity;
        }

        $groups = $this->loadCustomerGroupIds($entityId);
        $entity->setCustomerGroupIds($groups);

        return $entity;
    }

    private function loadCustomerGroupIds(int $entityId): array
    {
        $connection = $this->resourceConnection->getConnection();
        $select = $connection->select()
            ->from($this->ruleCustomerGroupTable, ['customer_group_id'])
            ->where('rule_id = ?', $entityId);

        return $connection->fetchCol($select);
    }
}
