<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\ResourceModel\Rule\Order\Grid;

use Amasty\Followup\Model\ResourceModel\Relation\Collection\Processor;
use Amasty\Followup\Model\ResourceModel\Relation\Collection\ProcessorFactory;
use Amasty\Followup\Model\ThirdParty\ModuleChecker;
use Magento\Framework\Data\Collection\Db\FetchStrategyInterface as FetchStrategy;
use Magento\Framework\Data\Collection\EntityFactoryInterface as EntityFactory;
use Magento\Framework\Event\ManagerInterface as EventManager;
use Magento\Framework\Stdlib\DateTime\TimezoneInterface;
use Magento\Sales\Model\ResourceModel\Order;
use Magento\Sales\Model\ResourceModel\Order\Grid\Collection as OrderGridCollection;
use Psr\Log\LoggerInterface as Logger;

class Collection extends OrderGridCollection
{
    /**
     * @var ModuleChecker
     */
    private $moduleChecker;

    /**
     * @var Processor
     */
    private $relationProcessor;

    public function __construct(
        EntityFactory $entityFactory,
        Logger $logger,
        FetchStrategy $fetchStrategy,
        EventManager $eventManager,
        ModuleChecker $moduleChecker,
        ProcessorFactory $relationProcessorFactory,
        $mainTable = 'sales_order_grid',
        $resourceModel = Order::class
    ) {
        $this->moduleChecker = $moduleChecker;
        $this->relationProcessor = $relationProcessorFactory->create(['collection' => $this]);
        parent::__construct(
            $entityFactory,
            $logger,
            $fetchStrategy,
            $eventManager,
            $mainTable,
            $resourceModel
        );
    }

    protected function _initSelect()
    {
        parent::_initSelect();

        $this->getSelect()
            ->joinInner(
                ['quote' => $this->getTable('quote')],
                'main_table.increment_id = quote.reserved_order_id',
                []
            );

        return $this;
    }

    public function addFieldToFilter($field, $condition = null)
    {
        if (in_array($field, ['segment_ids'])) {
            $this->addFilter('segment_ids', ['in' => $condition], 'public');

            return $this;
        }

        return parent::addFieldToFilter($field, $condition);
    }

    protected function _afterLoad()
    {
        if ($this->moduleChecker->isAmastySegmentEnabled()) {
            $this->relationProcessor->attachRelationDataToItem(
                'amasty_segments_index',
                'customer_id',
                'customer_id',
                'segment_ids',
                'segment_id'
            );
        }

        return parent::_afterLoad();
    }

    protected function _renderFiltersBefore()
    {
        if ($this->moduleChecker->isAmastySegmentEnabled()) {
            $this->relationProcessor->joinRelationTableByFilter(
                'segment_ids',
                'segment_id',
                'amasty_segments_index',
                'customer_id',
                'customer_id'
            );
        }

        parent::_renderFiltersBefore();
    }
}
