<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\ResourceModel\Rule;

use Amasty\Followup\Api\Data\RuleInterface;
use Amasty\Followup\Model\ResourceModel\Relation\Collection\Processor;
use Amasty\Followup\Model\ResourceModel\Relation\Collection\ProcessorFactory;
use Amasty\Followup\Model\ResourceModel\Rule as ResourceRule;
use Amasty\Followup\Model\Rule;
use Magento\Framework\Data\Collection\Db\FetchStrategyInterface;
use Magento\Framework\Data\Collection\EntityFactoryInterface;
use Magento\Framework\DB\Adapter\AdapterInterface;
use Magento\Framework\Event\ManagerInterface;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Psr\Log\LoggerInterface;

class Collection extends AbstractCollection
{
    /**
     * @var Processor
     */
    private $relationProcessor;

    public function __construct(
        EntityFactoryInterface $entityFactory,
        LoggerInterface $logger,
        FetchStrategyInterface $fetchStrategy,
        ManagerInterface $eventManager,
        ProcessorFactory $relationProcessorFactory,
        AdapterInterface $connection = null,
        AbstractDb $resource = null
    ) {
        $this->relationProcessor = $relationProcessorFactory->create(['collection' => $this]);
        parent::__construct($entityFactory, $logger, $fetchStrategy, $eventManager, $connection, $resource);
    }

    protected function _construct()
    {
        parent::_construct();
        $this->_init(Rule::class, ResourceRule::class);
        $this->_setIdFieldName($this->getResource()->getIdFieldName());
    }

    public function addStartFilter($types = [])
    {
        $this->addFilter('is_active', Rule::RULE_ACTIVE);
        $this->addFieldToFilter('start_event_type', ['in' => $types]);
        return $this;
    }

    public function addFieldToFilter($field, $condition = null)
    {
        $allowFields = [
            RuleInterface::SEGMENT_IDS,
            RuleInterface::CUSTOMER_GROUP_IDS,
            RuleInterface::CUSTOMER_GROUP_IDS
        ];
        if (in_array($field, $allowFields)) {
            $this->addFilter($field, ['in' => $condition], 'public');

            return $this;
        }

        return parent::addFieldToFilter($field, $condition);
    }

    protected function _afterLoad()
    {
        $this->relationProcessor->attachRelationDataToItem(
            ResourceRule::RULE_CUSTOMER_GROUP_TABLE,
            RuleInterface::RULE_ID,
            RuleInterface::RULE_ID,
            RuleInterface::CUSTOMER_GROUP_IDS,
            'customer_group_id'
        );
        $this->relationProcessor->attachRelationDataToItem(
            ResourceRule::RULE_STORE_TABLE,
            RuleInterface::RULE_ID,
            RuleInterface::RULE_ID,
            RuleInterface::STORE_IDS,
            'store_id'
        );
        $this->relationProcessor->attachRelationDataToItem(
            ResourceRule::RULE_SEGMENT_TABLE,
            RuleInterface::RULE_ID,
            RuleInterface::RULE_ID,
            RuleInterface::SEGMENT_IDS,
            'segment_id'
        );

        return parent::_afterLoad();
    }

    protected function _renderFiltersBefore()
    {
        $this->relationProcessor->joinRelationTableByFilter(
            RuleInterface::CUSTOMER_GROUP_IDS,
            'customer_group_id',
            ResourceRule::RULE_CUSTOMER_GROUP_TABLE,
            RuleInterface::RULE_ID,
            RuleInterface::RULE_ID
        );
        $this->relationProcessor->joinRelationTableByFilter(
            RuleInterface::STORE_IDS,
            'store_id',
            ResourceRule::RULE_STORE_TABLE,
            RuleInterface::RULE_ID,
            RuleInterface::RULE_ID
        );
        $this->relationProcessor->joinRelationTableByFilter(
            RuleInterface::SEGMENT_IDS,
            'segment_id',
            ResourceRule::RULE_SEGMENT_TABLE,
            RuleInterface::RULE_ID,
            RuleInterface::RULE_ID
        );

        parent::_renderFiltersBefore();
    }
}
