<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\ResourceModel\History;

use Amasty\Followup\Model\History;
use Amasty\Followup\Model\ResourceModel\History as HistoryResourceModel;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;

class Collection extends AbstractCollection
{
    protected function _construct()
    {
        parent::_construct();
        $this->_init(History::class, HistoryResourceModel::class);
        $this->_setIdFieldName($this->getResource()->getIdFieldName());
    }

    public function addRuleData()
    {
        $this->getSelect()
            ->joinLeft(
                ['rule' => $this->getTable('amasty_amfollowup_rule')],
                'main_table.rule_id = rule.rule_id',
                ['name']
            )
            ->joinLeft(
                ['schedule' => $this->getTable('amasty_amfollowup_schedule')],
                'main_table.rule_id = schedule.rule_id',
                ['GROUP_CONCAT(`schedule`.`delayed_start`)']
            )
        ->group('main_table.history_id');

        return $this;
    }

    public function addOrderData()
    {
        $this->getSelect()
            ->joinLeft(
                ['order' => $this->getTable('sales_order')],
                'main_table.order_id = order.entity_id',
                ['order_status' => 'order.status']
            );
        return $this;
    }

    public function addReadyFilter($date)
    {
        $this->addFieldToFilter('main_table.scheduled_at', ['lteq' => $date]);
        $this->addPendingStatusFilter();
        return $this;
    }

    public function addPendingStatusFilter($cond = 'eq')
    {
        $this->addFieldToFilter('main_table.status', [$cond => History::STATUS_PENDING]);

        return $this;
    }
}
