<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Mail;

use Magento\Framework\Url;

class TrackingPixelModifier
{
    /**
     * @var Url
     */
    private $urlBuilder;

    public function __construct(Url $urlBuilder)
    {
        $this->urlBuilder = $urlBuilder;
    }

    public function execute(string $hash, string $emailBody): string
    {
        $trackingUrl = $this->urlBuilder->getUrl('amasty_followup/email/open', ['uid' => $hash]);
        $emailBody = str_replace('</body>', '<img src="' . $trackingUrl . '"></body>', $emailBody);

        return $emailBody;
    }
}
