<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Mail\MessageBuilder;

use Laminas\Mail\Message;
use Magento\Framework\Mail\EmailMessageInterface;
use Magento\Framework\Mail\EmailMessageInterfaceFactory;
use Magento\Framework\Mail\MessageInterface;
use Magento\Framework\Mail\MimeMessageInterfaceFactory;
use Magento\Framework\ObjectManagerInterface;

class MessageBuilder
{
    /**
     * @var bool
     */
    private $legacyBuild = true;

    /**
     * @var EmailMessageInterfaceFactory|null
     */
    protected $emailMessageInterfaceFactory = null;

    /**
     * @var MimeMessageInterfaceFactory|null
     */
    protected $mimeMessageInterfaceFactory = null;

    public function __construct(
        ObjectManagerInterface $objectManager
    ) {
        if (interface_exists(EmailMessageInterface::class)) {
            $this->legacyBuild = false;
            $this->emailMessageInterfaceFactory = $objectManager->get(EmailMessageInterfaceFactory::class);
            $this->mimeMessageInterfaceFactory = $objectManager->get(MimeMessageInterfaceFactory::class);
        }
    }

    /**
     * Build email message
     *
     * @param EmailMessageInterface|MessageInterface $message
     *
     * @return EmailMessageInterface
     */
    public function build($message)
    {
        if (!$this->legacyBuild) {
            $messageData['body'] = $this->mimeMessageInterfaceFactory->create(
                ['parts' => $message->getBody()->getParts()]
            );
            $oldMessage = Message::fromString($message->getRawMessage());
            $messageData['from'][] = $oldMessage->getFrom()->current();
            $messageData['to'][] = $oldMessage->getTo()->current();

            foreach ($oldMessage->getBcc() as $bcc) {
                $messageData['bcc'][] = $bcc;
            }

            $messageData['subject'] = $oldMessage->getSubject();
            $message = $this->emailMessageInterfaceFactory->create($messageData);
        }

        return $message;
    }
}
