<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model;

use Magento\Framework\DataObject;
use Magento\Framework\Pricing\PriceCurrencyInterface;
use Magento\Framework\Stdlib\DateTime;

class Formatmanager extends DataObject
{
    public const TYPE_CUSTOMER = 'customer';
    public const TYPE_CUSTOMER_ID = 'customerId';
    public const TYPE_CUSTOMER_NAME = 'customerName';
    public const TYPE_CUSTOMER_EMAIL = 'customerEmail';
    public const TYPE_CUSTOMER_GROUP = 'customer_group';
    public const TYPE_CUSTOMER_GROUP_CODE = 'customerGroupCode';
    public const TYPE_CUSTOMER_LOG = 'customer_log';
    public const TYPE_HISTORY = 'history';
    public const TYPE_HISTORY_ID = 'historyId';
    public const TYPE_HISTORY_COUPON_CODE = 'couponCode';
    public const TYPE_ORDER = 'order';
    public const TYPE_ORDER_STATUS = 'orderStatus';
    public const TYPE_ORDER_ID = 'orderId';
    public const TYPE_ORDER_INCREMENT_ID = 'orderIncrementId';
    public const TYPE_ORDER_SHIPPING_METHOD = 'shippingMethod';
    public const TYPE_QUOTE_ID = 'quoteId';
    public const TYPE_ORDER_FORMATTED_SHIPPING_ADDRESS = 'formattedShippingAddress';
    public const TYPE_ORDER_FORMATTED_BILLING_ADDRESS = 'formattedBillingAddress';
    public const TYPE_ORDER_PAYMENT_METHOD = 'paymentMethod';

    /**
     * @var array
     */
    protected $config;

    /**
     * @var DateTime
     */
    protected $dateTime;

    /**
     * @var PriceCurrencyInterface
     */
    protected $priceCurrency;

    /**
     * @var DateTime\DateTime
     */
    private $_date;

    public function init($config)
    {
        $this->config = $config;

        return $this;
    }

    public function __construct(
        \Magento\Framework\Stdlib\DateTime\DateTime $date,
        DateTime $dateTime,
        PriceCurrencyInterface $priceCurrency,
        array $data = []
    ) {
        $this->dateTime = $dateTime;
        $this->_date = $date;
        $this->priceCurrency = $priceCurrency;
    }

    public function formatDate($type, $field)
    {
        $ret = null;
        $object = $this->config[$type] ?? null;

        if ($object) {
            if ($type == 'customer_log'
                || $type == 'customer'
            ) {
                switch ($field) {
                    case 'last_login_at':
                        $ret = $this->dateTime->formatDate($object->getLastLoginAt(), false);
                        break;
                    case 'created_at':
                        $ret = $object->getCreatedAt();
                        break;
                }
            } else {
                $ret = $this->dateTime->formatDate($object->getData($field), false);
            }
        }

        return $ret;
    }

    public function formatTime($type, $field)
    {

        $ret = null;
        $object = $this->config[$type] ?? null;

        if ($object) {
            $ret = $this->dateTime->formatDate($object->getData($field), true);
        }

        return $ret;
    }

    public function formatPrice($type, $field)
    {
        if (isset($this->config[$type])) {
            $object = $this->config[$type];
            return $this->priceCurrency->format(
                $object->getData($field),
                true,
                PriceCurrencyInterface::DEFAULT_PRECISION,
                $object->getStore()
            );
        }
        return null;
    }
}
