<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Factories;

use \Amasty\Segments\Model\ResourceModel\Customer\Collection;

class SegmentFactory
{
    public const AMASTY_SEGMENTS_SEGMENT_REPOSITORY_MODEL_PATH = \Amasty\Segments\Model\SegmentRepository::class;
    public const AMASTY_SEGMENTS_SEGMENT_COLLECTION_MODEL_PATH =
        \Amasty\Segments\Model\ResourceModel\Segment\Collection::class;

    /**
     * @var \Magento\Framework\ObjectManagerInterface
     */
    protected $objectManager;

    /**
     * SegmentFactory constructor.
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     */
    public function __construct(
        \Magento\Framework\ObjectManagerInterface $objectManager
    ) {
        $this->objectManager = $objectManager;
    }

    /**
     * @return mixed
     */
    public function getSegmentRepository()
    {
        return $this->objectManager->create(self::AMASTY_SEGMENTS_SEGMENT_REPOSITORY_MODEL_PATH);
    }

    /**
     * @return mixed
     */
    public function getSegmentCollection()
    {
        return $this->objectManager->create(self::AMASTY_SEGMENTS_SEGMENT_COLLECTION_MODEL_PATH);
    }

    /**
     * @return string
     */
    public function getValidationField()
    {
        return Collection::AMASTY_SEGMENTS_INDEX_TABLE_CUSTOMER_FIELD_NAME;
    }
}
