<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Event\Order;

class Ship extends \Amasty\Followup\Model\Event\Order\Status
{
    /**
     * @var string
     */
    protected $_statusKey = self::STATUS_KEY_SHIP_ORDER;

    /**
     * @inheritdoc
     */
    protected function addFilters($collection)
    {
        $collection->getSelect()->joinInner(
            ['shipment' => $collection->getTable('sales_shipment')],
            'order.entity_id = shipment.order_id',
            []
        );

        $this->addDateRange($collection, 'shipment.created_at');
    }
}
