<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Event\Order;

class Cancel extends \Amasty\Followup\Model\Event\Order\Status
{
    /**
     * @var string
     */
    protected $_statusKey = self::STATUS_KEY_CANCEL_ORDER;

    /**
     * @inheritdoc
     */
    protected function addFilters($collection)
    {
        $collection->addFieldToFilter(
            'order.' . \Magento\Sales\Api\Data\OrderInterface::STATE,
            [
                'eq' => \Magento\Sales\Model\Order::STATE_CANCELED
            ]
        );

        $this->addDateRange($collection, 'order.updated_at');
    }
}
