<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Event\Customer;

use Amasty\Followup\Helper\Data;
use Amasty\Followup\Model\ConfigProvider;
use Amasty\Followup\Model\Event\Basic;
use Amasty\Followup\Model\Factories\SegmentFactory;
use Amasty\Followup\Model\FlagRegistry;
use Amasty\Followup\Model\Rule;
use Magento\Customer\Model\Customer;
use Magento\Customer\Model\Data\Customer as CustomerDataModel;
use Magento\Customer\Model\ResourceModel\Customer\Collection as CustomerCollection;
use Magento\Customer\Model\ResourceModel\Customer\CollectionFactory;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\Stdlib\DateTime;
use Magento\Sales\Model\Order\Status as OrderStatus;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Wishlist\Model\WishlistFactory;

class Wishlist extends Basic
{
    /**
     * @var WishlistFactory
     */
    private $wishlistFactory;

    public function __construct(
        StoreManagerInterface $storeManager,
        Rule $rule,
        Data $helper,
        ConfigProvider $configProvider,
        DateTime\DateTime $date,
        DateTime $dateTime,
        ObjectManagerInterface $objectManager,
        CollectionFactory $collectionCustomerFactory,
        SegmentFactory $segmentFactory,
        FlagRegistry $flagRegistry,
        WishlistFactory $wishlistFactory,
        ?OrderStatus $status = null,
        array $data = []
    ) {
        parent::__construct(
            $storeManager,
            $rule,
            $helper,
            $configProvider,
            $date,
            $dateTime,
            $objectManager,
            $collectionCustomerFactory,
            $segmentFactory,
            $flagRegistry,
            $status,
            $data
        );
        $this->wishlistFactory = $wishlistFactory;
    }

    /**
     * @param CustomerDataModel|Customer $customer
     * @return bool
     */
    public function validate($customer): bool
    {
        $validateWishlist = $this->validateWishListBasic($customer);

        return $validateWishlist;
    }

    /**
     * @param CustomerDataModel|Customer $customer
     * @return bool
     */
    protected function validateWishListBasic($customer): bool
    {
        $validateWishlist = false;
        $storeId = $this->getStoreIdFromCustomer($customer);

        $validateBasic = $this->_validateBasic(
            $storeId,
            $customer->getEmail(),
            (int)$customer->getGroupId()
        );

        if ($validateBasic) {
            $wishlist = $this->wishlistFactory->create(['useCurrentWebsite' => false]);
            $wishlist->loadByCustomerId($customer->getId());
            $wishlist->setStore($storeId);
            $wishlist->setSharedStoreIds([$storeId]);
            $validateWishlist = (bool)$wishlist->getItemsCount();
        }

        return $validateWishlist;
    }

    protected function _initCollection(): CustomerCollection
    {
        $collection = $this->customerCollectionFactory->create();
        $collection->addNameToSelect();

        $collection->getSelect()->joinInner(
            ['wishlist' => $collection->getTable('wishlist')],
            'e.entity_id = wishlist.customer_id',
            []
        )->joinInner(
            ['wishlist_item' => $collection->getTable('wishlist_item')],
            'wishlist.wishlist_id = wishlist_item.wishlist_id',
            []
        );

        $collection->getSelect()->where(
            "wishlist_item.added_at > '"
            . $this->_dateTime->formatDate($this->getLastExecuted())
            . "'"
        );

        $collection->getSelect()->where(
            "wishlist_item.added_at < '"
            . $this->_dateTime->formatDate($this->getCurrentExecution())
            . "'"
        );

        $collection->getSelect()->group("e.entity_id");

        return $collection;
    }
}
