<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Event\Customer;

use Amasty\Followup\Model\Event\Basic;
use Magento\Customer\Model\Customer;
use Magento\Customer\Model\Data\Customer as CustomerDataModel;
use Magento\Newsletter\Model\Subscriber;

class Subscription extends Basic
{
    /**
     * @param CustomerDataModel|Customer $customer
     * @return bool
     */
    public function validate($customer): bool
    {
        return $this->_validateBasic(
            $this->getStoreIdFromCustomer($customer),
            $customer->getEmail(),
            (int)$customer->getGroupId()
        );
    }

    public function validateSubscription(Subscriber $subscriber, Customer $customer): bool
    {
        $isValidCustomer = $this->validate($customer);
        $isValidSubscriber = $subscriber->getSubscriberStatus() === Subscriber::STATUS_SUBSCRIBED;

        return $isValidCustomer && $isValidSubscriber;
    }
}
