<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Event\Customer;

use Amasty\Followup\Model\Event\Basic;
use Magento\Customer\Model\Customer;
use Magento\Customer\Model\Data\Customer as CustomerDataModel;

class NewCustomer extends Basic
{
    /**
     * @param CustomerDataModel|Customer $customer
     * @return bool
     */
    public function validate($customer): bool
    {
        if ($customer instanceof CustomerDataModel) {
            $entityId = $customer->getId();
        } else {
            $entityId = $customer->getEntityId();
        }

        $validateBasic = $this->_validateBasic(
            $this->getStoreIdFromCustomer($customer),
            $customer->getEmail(),
            (int)$customer->getGroupId()
        );

        return $validateBasic && $entityId === null;
    }
}
