<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Event\Customer;

use Amasty\Followup\Model\Event\Basic;
use Magento\Customer\Api\Data\CustomerInterface;
use Magento\Customer\Model\Customer;
use Magento\Customer\Model\Data\Customer as CustomerDataModel;

class Group extends Basic
{
    /**
     * @param CustomerDataModel|Customer $afterCustomer
     * @return bool
     */
    private function isGroupChanged(
        $afterCustomer
    ): bool {
        $newData = $afterCustomer->getData();
        $newCustomerGroup = $afterCustomer->getGroupId();
        $origData = $afterCustomer->getOrigData();

        if (!$origData) {
            $afterCustomer->load($afterCustomer->getId());
            $origData = $afterCustomer->getOrigData();
            $afterCustomer->setData($newData);
        }

        $isGroupChanged = is_array($origData) && isset($origData[CustomerInterface::GROUP_ID])
            && (int)$origData[CustomerInterface::GROUP_ID] !== $newCustomerGroup;

        return $isGroupChanged;
    }

    /**
     * @param CustomerDataModel|Customer $afterCustomer
     * @return bool
     */
    public function validate($afterCustomer): bool
    {
        $validateBasic = $this->_validateBasic(
            $this->getStoreIdFromCustomer($afterCustomer),
            $afterCustomer->getEmail(),
            $afterCustomer->getGroupId()
        );

        $isGroupChanged = $this->isGroupChanged($afterCustomer);

        return $validateBasic && $isGroupChanged;
    }
}
