<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Event\Customer;

use Amasty\Followup\Model\Event\Basic;
use Magento\Customer\Model\Customer;
use Magento\Customer\Model\Data\Customer as CustomerDataModel;
use Magento\Customer\Model\ResourceModel\Customer\Collection as CustomerCollection;

class Date extends Basic
{
    /**
     * @param CustomerDataModel|Customer $customer
     * @return bool
     */
    public function validate($customer): bool
    {
        return $this->_validateBasic(
            $this->getStoreIdFromCustomer($customer),
            $customer->getEmail(),
            (int)$customer->getGroupId()
        );
    }

    protected function _initCollection(): CustomerCollection
    {
        $collection = $this->customerCollectionFactory->create();

        $collection->addNameToSelect();

        $today = $this->_date->date('Y-m-d');

        $collection->getSelect()->joinInner(
            ['rule' => $collection->getTable('amasty_amfollowup_rule')],
            'rule.rule_id = ' . $this->_rule->getId() . ' and '.
            $collection->getConnection()->quoteInto('rule.customer_date_event = ?', $today),
            []
        );

        $collection->getSelect()->joinLeft(
            ['history' => $collection->getTable('amasty_amfollowup_history')],
            'e.entity_id = history.customer_id and '.
            'history.rule_id = ' . $this->_rule->getId(),
            []
        );

        $collection->getSelect()->where("history.history_id is null");

        return $collection;
    }
}
