<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Event\Customer;

use Amasty\Followup\Model\Event\Basic;
use Magento\Customer\Model\Customer;
use Magento\Customer\Model\Data\Customer as CustomerDataModel;
use Magento\Customer\Model\ResourceModel\Customer\Collection as CustomerCollection;

class Birthday extends Basic
{
    /**
     * @param CustomerDataModel|Customer $customer
     * @return bool
     */
    public function validate($customer): bool
    {
        return $this->_validateBasic(
            $this->getStoreIdFromCustomer($customer),
            $customer->getEmail(),
            (int)$customer->getGroupId()
        );
    }

    protected function _initCollection(): CustomerCollection
    {
        $days = $this->configProvider->getBirthdayOffset();
        $modifiedDate = (($days > 0) ? $this->getCurrentExecution() - $days : $this->getCurrentExecution());
        $collection = $this->customerCollectionFactory->create();
        $collection->addNameToSelect();

        $collection->getSelect()->joinLeft(
            ['history' => $collection->getTable('amasty_amfollowup_history')],
            'e.entity_id = history.customer_id and '.
            'history.rule_id = ' . $this->_rule->getId() . ' and '.
            'DATEDIFF(history.created_at, "' . $this->_dateTime->formatDate($this->getCurrentExecution()) . '") = 0',
            []
        );

        $collection->addExpressionAttributeToSelect('birth_month', 'MONTH({{dob}})', 'dob')
            ->addExpressionAttributeToSelect('birth_day', 'DAY({{dob}})', 'dob')
            ->joinAttribute('dob', 'customer/dob', 'entity_id', null, 'left')
            ->addFieldToFilter('birth_month', ['eq' =>
                $this->_date->date("m", $modifiedDate)])
            ->addFieldToFilter('birth_day', ['eq' =>
                $this->_date->date("d", $modifiedDate)]);

        $collection->getSelect()->where("history.history_id is null");

        return $collection;
    }
}
