<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Event\Customer;

use Amasty\Followup\Model\Event\Basic;
use Amasty\Followup\Model\History as History;
use Magento\Customer\Model\Customer;
use Magento\Customer\Model\Data\Customer as CustomerDataModel;
use Magento\Customer\Model\ResourceModel\Customer\Collection as CustomerCollection;

class Activity extends Basic
{
    /**
     * @param CustomerDataModel|Customer $customer
     * @return bool
     */
    public function validate($customer): bool
    {
        return $this->_validateBasic(
            $this->getStoreIdFromCustomer($customer),
            $customer->getEmail(),
            (int)$customer->getGroupId()
        );
    }

    protected function _initCollection(): CustomerCollection
    {
        $winbackPeriod = $this->configProvider->getWinbackPeriod();
        $collection = $this->customerCollectionFactory->create();
        $collection->addNameToSelect();

        $collection->getSelect()->joinRight(
            ['log' => $collection->getTable('customer_log')],
            'e.entity_id = log.customer_id',
            []
        );

        $collection->getSelect()->joinLeft(
            ['history_n_canceled' => $collection->getTable('amasty_amfollowup_history')],
            'e.entity_id = history_n_canceled.customer_id and '.
            'history_n_canceled.rule_id = ' . $this->_rule->getId() . ' and ' .
            'history_n_canceled.status <> "' . History::STATUS_CANCEL . '"',
            []
        );

        $collection->getSelect()->where("history_n_canceled.history_id is null");

        $collection->getSelect()->where(
            'log.last_login_at > ?',
            $this->_dateTime->formatDate($this->getLastExecuted() - $winbackPeriod)
        );

        $collection->getSelect()->group("e.entity_id");

        $collection->getSelect()->having(
            "MAX(log.last_login_at) < '"
            . $this->_dateTime->formatDate($this->getCurrentExecution() - $winbackPeriod)
            . "'"
        );

        return $collection;
    }
}
