<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Event\Cancel\Order;

class Complete extends \Amasty\Followup\Model\Event\Basic
{
    public function validate($history)
    {
        $collection = $this->_objectManager
            ->create(\Magento\Sales\Model\ResourceModel\Order\Collection::class);

        if ($history->getOrderId()) {
            $collection->addFieldToFilter('entity_id', ['gt' => $history->getOrderId()]);
        } else {
            $collection->addFieldToFilter('created_at', ['gteq' => $history->getCreatedAt()]);
        }

        if ($history->getCustomerId()) {
            $collection->addFieldToFilter('customer_id', ['eq' => $history->getCustomerId()]);
        } else {
            $collection->addFieldToFilter('customer_email', ['eq' => $history->getEmail()]);
        }

        return $collection->getSize() > 0;
    }
}
