<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Event\Cancel\Customer\Wishlist;

use Amasty\Followup\Helper\Data;
use Amasty\Followup\Model\ConfigProvider;
use Amasty\Followup\Model\Event\Basic;
use Amasty\Followup\Model\Factories\SegmentFactory;
use Amasty\Followup\Model\FlagRegistry;
use Amasty\Followup\Model\History;
use Amasty\Followup\Model\Rule;
use Magento\Customer\Model\ResourceModel\Customer\CollectionFactory;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\Stdlib\DateTime;
use Magento\Sales\Model\Order\Status as OrderStatus;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Wishlist\Model\ResourceModel\Item\CollectionFactory as WishlistItemsCollectionFactory;

class Updated extends Basic
{
    /**
     * @var WishlistItemsCollectionFactory
     */
    private $wishlistItemsCollectionFactory;

    public function __construct(
        StoreManagerInterface $storeManager,
        Rule $rule,
        Data $helper,
        ConfigProvider $configProvider,
        DateTime\DateTime $date,
        DateTime $dateTime,
        ObjectManagerInterface $objectManager,
        CollectionFactory $collectionCustomerFactory,
        SegmentFactory $segmentFactory,
        FlagRegistry $flagRegistry,
        WishlistItemsCollectionFactory $wishlistItemsCollectionFactory,
        ?OrderStatus $status = null,
        array $data = []
    ) {
        $this->wishlistItemsCollectionFactory = $wishlistItemsCollectionFactory;
        parent::__construct(
            $storeManager,
            $rule,
            $helper,
            $configProvider,
            $date,
            $dateTime,
            $objectManager,
            $collectionCustomerFactory,
            $segmentFactory,
            $flagRegistry,
            $status,
            $data
        );
    }

    /**
     * @param History $history
     * @return bool
     */
    public function validate($history): bool
    {
        $wishlistCollection = $this->wishlistItemsCollectionFactory->create();
        $wishlistCollection->addCustomerIdFilter($history->getCustomerId());
        $wishlistCollection->addStoreFilter([$history->getStoreId()]);
        $wishlistCollection->addFieldToFilter('added_at', ['gt' => $history->getCreatedAt()]);

        return (bool)$wishlistCollection->getSize();
    }
}
