<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Event\Cancel\Customer\Wishlist;

class Shared extends \Amasty\Followup\Model\Event\Basic
{
    public function validate($history)
    {
        $collection = $this->_objectManager
            ->create(\Magento\Wishlist\Model\ResourceModel\Wishlist\Collection::class)
            ->addFieldToFilter('customer_id', ['eq' => $history->getCustomerId()])
            ->addFieldToFilter('shared', ['gt' => 0])
            ->addFieldToFilter('updated_at', ['gt' => $history->getCreatedAt()]);

        return $collection->getSize() > 0;
    }
}
