<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Event\Cancel\Customer;

use Amasty\Followup\Helper\Data;
use Amasty\Followup\Model\ConfigProvider;
use Amasty\Followup\Model\Event\Basic;
use Amasty\Followup\Model\Factories\SegmentFactory;
use Amasty\Followup\Model\FlagRegistry;
use Amasty\Followup\Model\History;
use Amasty\Followup\Model\Rule;
use Magento\Customer\Model\Logger;
use Magento\Customer\Model\ResourceModel\Customer\CollectionFactory as CustomerCollectionFactory;
use Magento\Customer\Model\ResourceModel\CustomerRepository;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\Stdlib\DateTime;
use Magento\Sales\Model\Order\Status as OrderStatus;
use Magento\Store\Model\StoreManagerInterface;

class Loggedin extends Basic
{
    /**
     * @var CustomerRepository
     */
    private $customerRepository;

    /**
     * @var Logger
     */
    private $customerLogger;

    public function __construct(
        StoreManagerInterface $storeManager,
        Rule $rule,
        Data $helper,
        ConfigProvider $configProvider,
        DateTime\DateTime $date,
        DateTime $dateTime,
        ObjectManagerInterface $objectManager,
        CustomerCollectionFactory $collectionCustomerFactory,
        SegmentFactory $segmentFactory,
        FlagRegistry $flagRegistry,
        CustomerRepository $customerRepository,
        Logger $customerLogger,
        ?OrderStatus $status = null,
        array $data = []
    ) {
        $this->customerRepository = $customerRepository;
        $this->customerLogger = $customerLogger;

        parent::__construct(
            $storeManager,
            $rule,
            $helper,
            $configProvider,
            $date,
            $dateTime,
            $objectManager,
            $collectionCustomerFactory,
            $segmentFactory,
            $flagRegistry,
            $status,
            $data
        );
    }

    /**
     * @param History $history
     * @return bool
     */
    public function validate($history): bool
    {
        $customer = $this->customerRepository->get($history->getEmail());
        $logCustomer = $this->customerLogger->get($customer->getId());

        return strtotime((string)$logCustomer->getLastLoginAt()) > strtotime((string)$history->getCreatedAt());
    }
}
