<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Event\Cancel\Customer;

class Clicklink extends \Amasty\Followup\Model\Event\Basic
{
    public function validate($history)
    {
        $collectionLink = $this->_objectManager
            ->create(\Amasty\Followup\Model\ResourceModel\Link\Collection::class)
            ->addFieldToFilter('customer_id', ['eq' => $history->getCustomerId()])
            ->addFieldToFilter('created_at', ['gt' => $history->getCreatedAt()]);

        $collectionHistoryLink = $this->_objectManager
            ->create(\Amasty\Followup\Model\ResourceModel\Link\Collection::class)
            ->addHistoryData()
            ->addFieldToFilter('schedule_id', ['eq' => $history->getScheduleId()])
            ->addFieldToFilter('main_table.customer_id', ['null' => true])
            ->addFieldToFilter('main_table.created_at', ['gt' => $history->getCreatedAt()]);

        return $collectionLink->getSize() > 0 || $collectionHistoryLink->getSize() > 0;
    }
}
