<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model;

use Amasty\Base\Model\ConfigProviderAbstract;
use Magento\Store\Model\ScopeInterface;

class ConfigProvider extends ConfigProviderAbstract
{
    public const XPATH_TEST_RECIPIENT = 'test/recipient';
    public const XPATH_SAFE_MODE = 'test/safe_mode';
    public const XPATH_WINBACK_PERIOD = 'general/winback_period';
    public const XPATH_BIRTHDAY_OFFSET = 'general/birthday_offset';

    /**
     * @var string
     */
    protected $pathPrefix = 'amfollowup/';

    public function isSafeMode($storeId = null): bool
    {
        return (bool)$this->getValue(self::XPATH_SAFE_MODE, $storeId);
    }

    public function getRecipientEmailForTest(): ?string
    {
        $recipientEmail = $this->getGlobalValue(self::XPATH_TEST_RECIPIENT);

        if (empty($recipientEmail)
            || !filter_var($recipientEmail, FILTER_VALIDATE_EMAIL)
        ) {
            $recipientEmail = null;
        }

        return $recipientEmail;
    }

    public function getPaymentMethodTitle(string $paymentMethod, int $storeId): string
    {
        return $this->scopeConfig->getValue(
            sprintf('payment/%s/title', $paymentMethod),
            ScopeInterface::SCOPE_STORE,
            $storeId
        ) ?? '';
    }

    public function getWinbackPeriod(?int $storeId = null): int
    {
        return (int)$this->getValue(self::XPATH_WINBACK_PERIOD, $storeId) * 24 * 60 * 60;
    }

    public function getBirthdayOffset(?int $storeId = null): int
    {
        return (int)$this->getValue(self::XPATH_BIRTHDAY_OFFSET, $storeId) * 24 * 60 * 60;
    }
}
