<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Helper;

use Amasty\Followup\Model\Rule as Rule;
use Magento\Email\Model\ResourceModel\Template;
use Magento\Email\Model\Template as EmailTemplate;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\Registry;
use Magento\Sales\Model\Order as SalesOrder;
use Magento\Sales\Model\ResourceModel\Order\Status\Collection;

class Data extends AbstractHelper
{
    public const AMASTY_SEGMENT_MODULE_DEPEND_NAMESPACE = 'Amasty_Segments';
    public const SECONDS_IN_DAY = 24 * 60 * 60;
    public const SECONDS_IN_HOUR = 60 * 60;
    public const SECONDS_IN_MINUTE = 60;

    /**
     * @var Registry
     */
    protected $coreRegistry;

    /**
     * @var ObjectManagerInterface
     */
    protected $_objectManager;

    /**
     * @var ScopeConfigInterface
     */
    protected $_scopeConfig;

    /**
     * @var Template
     */
    private $templateResourceModel;

    /**
     * @var Template\CollectionFactory
     */
    private $templateCollectionFactory;

    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        ObjectManagerInterface $objectManager,
        \Magento\Email\Model\ResourceModel\Template $templateResourceModel,
        Registry $registry,
        \Magento\Email\Model\ResourceModel\Template\CollectionFactory $templateCollectionFactory
    ) {
        $this->coreRegistry = $registry;
        parent::__construct($context);
        $this->_objectManager = $objectManager;
        $this->_scopeConfig = $context->getScopeConfig();
        $this->templateResourceModel = $templateResourceModel;
        $this->templateCollectionFactory = $templateCollectionFactory;
    }

    public function getScopeValue($path, $scoreCode = null)
    {
        return $this->_scopeConfig->getValue($path, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $scoreCode);
    }

    public function createTemplate($templateCode, $templateLabel)
    {
        $template = $this->_objectManager
            ->create(EmailTemplate::class);
        $template->setForcedArea($templateCode);
        $template->loadDefault($templateCode);
        $template->setData('is_legacy', true);
        $template->setData('orig_template_code', $templateCode);
        $template->setData('template_variables', json_encode($template->getVariablesOptionArray(true)));
        $template->setData('template_code', $templateLabel);
        $template->setTemplateType(EmailTemplate::TYPE_HTML);
        $template->setId(null);
        if (!$this->templateResourceModel->checkCodeUsage($template)) {
            $template->save();
        }
    }

    public function getDays($timestamp)
    {
        return $timestamp > 0 && floor($timestamp / self::SECONDS_IN_DAY) ?
            floor($timestamp / self::SECONDS_IN_DAY) :
            null;
    }

    public function getHours($timestamp)
    {
        $days = $this->getDays($timestamp);
        $time = $timestamp - ($days * self::SECONDS_IN_DAY);

        return $time > 0 ?
            floor($time / self::SECONDS_IN_HOUR) :
            null;
    }

    public function getMinutes($timestamp)
    {
        $days = $this->getDays($timestamp);
        $hours = $this->getHours($timestamp);
        $time = $timestamp - ($days * self::SECONDS_IN_DAY) - ($hours * self::SECONDS_IN_HOUR);

        return $time > 0 ?
            floor($time / self::SECONDS_IN_MINUTE) :
            null;
    }
}
