<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */
namespace Amasty\Followup\Cron;

use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Stdlib\DateTime;
use Magento\SalesRule\Model\ResourceModel\Rule\CollectionFactory;

class ClearCoupons
{
    /**
     * @var DateTime
     */
    protected $_dateTime;

    /**
     * @var DateTime\DateTime
     */
    protected $_date;

    /**
     * @var CollectionFactory
     */
    protected $ruleCollectionFactory;

    public function __construct(
        CollectionFactory $ruleCollectionFactory,
        \Magento\Framework\Stdlib\DateTime\DateTime $date,
        DateTime $dateTime
    ) {
        $this->_dateTime = $dateTime;
        $this->_date = $date;
        $this->ruleCollectionFactory = $ruleCollectionFactory;
    }

    public function execute()
    {
        $formattedDate = $this->_dateTime->formatDate($this->_date->gmtTimestamp());

        $collection = $this->ruleCollectionFactory->create();

        $collection->getSelect()->joinLeft(
            ['history' => $collection->getTable('amasty_amfollowup_history')],
            'main_table.rule_id = history.sales_rule_id',
            []
        );

        $collection->addFieldToFilter('coupon_to_date', ['lt' => $formattedDate]);

        foreach ($collection as $coupon) {
            $coupon->delete();
        }
    }
}
