<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Controller\Email;

use Amasty\Followup\Model\ResourceModel\History\Collection;
use Magento\Framework\Controller\ResultFactory;

class Url extends \Magento\Framework\App\Action\Action
{
    /**
     * @var \Magento\Framework\Url\Decoder
     */
    protected $decoder;

    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Framework\Url\Decoder $decoder
    ) {
        parent::__construct($context);
        $this->decoder = $decoder;
    }

    protected function _getHistory()
    {
        $ret = null;

        $id = $this->getRequest()->getParam('id');
        $key = $this->getRequest()->getParam('key');

        $historyResource = $this->_objectManager->create(Collection::class)
            ->addFieldToFilter('main_table.history_id', $id);

        if ($historyResource->getSize() > 0) {
            $items = $historyResource->getItems();
            $history = end($items);

            if ($history->getId() && $history->getPublicKey() == $key) {
                $ret = $history;
            }
        }
        return $ret;
    }

    public function execute()
    {
        $url = $this->getRequest()->getParam('url');
        $mageUrl = $this->getRequest()->getParam('mageUrl');

        $history = $this->_getHistory();

        if ($history && ($url || $mageUrl)) {

            $target = null;

            if ($url) {
                $target = $this->decoder->decode($url);
            } elseif ($mageUrl) {
                $target = $this->_url->getUrl($this->decoder->decode($mageUrl));
            }

            $this->_loginCustomer($history);

            $link = $this->_objectManager->get(\Amasty\Followup\Model\Link::class);
            $link->setData([
                "customer_id" => $history->getCustomerId(),
                "history_id" => $history->getId(),
                "link" => $target
            ]);
            $link->save();

            return $this->getResponse()->setRedirect($target);
        } else {
            $result = $this->resultFactory->create(ResultFactory::TYPE_FORWARD);

            return $result->forward('defaultNoRoute');
        }
    }

    protected function _loginCustomer($history)
    {
        $customerSession = $this->_objectManager->get(\Magento\Customer\Model\Session::class);
        $checkoutSession = $this->_objectManager->get(\Magento\Checkout\Model\Session::class);

        if ($customerSession->isLoggedIn()) {
            if ($history->getCustomerId() != $customerSession->getCustomerId()) {
                $customerSession->logout();
            }
        }

        // customer. login
        if ($history->getCustomerId()) {

            $customer = $this->_objectManager->get(\Magento\Customer\Model\Customer::class)
                ->load($history->getCustomerId());

            if ($customer->getId()) {
                $customerSession->setCustomerAsLoggedIn($customer);
            }
        } elseif ($history->getQuoteId()) {
            //visitor. restore quote in the session
            $quote = $this->_objectManager->get(\Magento\Quote\Model\Quote::class)
                ->load($history->getQuoteId());

            if ($quote) {
                $checkoutSession->replaceQuote($quote);
                $quote->getBillingAddress()->setEmail($history->getEmail());
            }
        }

        if ($history->getSalesRuleCoupon()) {

            $code = $history->getSalesRuleCoupon();
            $quote = $checkoutSession->getQuote();
            if ($code && $quote) {

                $quote->setCouponCode($code)
                    ->collectTotals()
                    ->save();
            }
        }
    }
}
