<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Controller\Email;

class Unsubscribe extends \Amasty\Followup\Controller\Email\Url
{
    public function execute()
    {
        $history = $this->_getHistory();

        if ($history) {
            $blacklist = $this->_objectManager->create(\Amasty\Followup\Model\Blacklist::class)
                ->load($history->getEmail(), 'email');

            if (!$blacklist->getId()) {
                $blacklist->addData([
                    'email' => $history->getEmail()
                ]);

                $blacklist->save();
            }
            $this->messageManager->addSuccess(__('You have been unsubscribed'));
        }

        return $this->resultRedirectFactory->create()->setRefererUrl();
    }
}
