<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Controller\Email;

use Amasty\Followup\Model\History;
use Amasty\Followup\Model\ResourceModel\History\CollectionFactory;
use Magento\Framework\App\ActionInterface;
use Magento\Framework\App\PageCache\NotCacheableInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\ResultFactory;

class Open implements ActionInterface, NotCacheableInterface
{
    /**
     * @var ResultFactory
     */
    private $resultFactory;

    /**
     * @var RequestInterface
     */
    private $request;

    /**
     * @var CollectionFactory
     */
    private $historyCollectionFactory;

    public function __construct(
        ResultFactory $resultFactory,
        RequestInterface $request,
        CollectionFactory $historyCollectionFactory
    ) {
        $this->resultFactory = $resultFactory;
        $this->request = $request;
        $this->historyCollectionFactory = $historyCollectionFactory;
    }

    public function execute()
    {
        try {
            if ($uid = $this->request->getParam('uid')) {
                $historyCollection = $this->historyCollectionFactory->create();
                $historyCollection->addFieldToFilter('main_table.public_key', $uid)
                    ->setCurPage(1)
                    ->setPageSize(1);
                /** @var History $history */
                $history = $historyCollection->getFirstItem();

                if ($history->getHistoryId()) {
                    $history->setOpened($history->getOpened() + 1);
                    $history->save();
                }
            }
        } catch (\Exception $e) {
            null;
        }

        $base64Pixel = 'R0lGODlhAQABAIAAAP///wAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==';
        $resultRaw = $this->resultFactory->create(ResultFactory::TYPE_RAW);
        $resultRaw->setHeader('Content-Type', 'image/gif');
        $resultRaw->setHeader('Content-Length', strlen($base64Pixel));
        $resultRaw->setContents($base64Pixel);

        return $resultRaw;
    }
}
