<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */
namespace Amasty\Followup\Controller\Adminhtml\Queue;

use Magento\Framework\Exception\NoSuchEntityException;

class Save extends \Amasty\Followup\Controller\Adminhtml\Queue
{
    public function execute()
    {
        if ($this->getRequest()->getPostValue()) {
            $data = $this->getRequest()->getPostValue();

            try {
                $model = $this->_objectManager->create(\Amasty\Followup\Model\History::class);

                $id = $this->getRequest()->getParam('history_id');

                if ($id) {
                    $model->load($id);
                    if ($id != $model->getId()) {
                        throw new \Magento\Framework\Exception\LocalizedException(__('The wrong queue is specified.'));
                    }
                }

                $model->setData($data);

                $model->save();

                $this->messageManager->addSuccess(__('You saved the queue item.'));

                if ($this->getRequest()->getParam('back')) {
                    return $this->resultRedirectFactory->create()->setPath(
                        'amasty_followup/*/edit',
                        ['id' => $model->getId()]
                    );
                }

                return $this->resultRedirectFactory->create()->setPath('amasty_followup/*/');
            } catch (\Magento\Framework\Exception\LocalizedException $e) {
                $this->messageManager->addError($e->getMessage());
                $id = (int)$this->getRequest()->getParam('history_id');

                $resultRedirect = $this->resultRedirectFactory->create();
                if (!empty($id)) {
                    $resultRedirect->setPath('amasty_followup/*/edit', ['id' => $id]);
                } else {
                    $resultRedirect->setPath('amasty_followup/*/index');
                }

                return $resultRedirect;
            } catch (\Exception $e) {
                $this->messageManager->addError(
                    __('Something went wrong while saving the queue data. Please review the error log.')
                );
                $this->_objectManager->get(\Psr\Log\LoggerInterface::class)->critical($e);
                $this->_objectManager->get(\Magento\Backend\Model\Session::class)->setPageData($data);

                return $this->resultRedirectFactory->create()->setPath(
                    'amasty_followup/*/edit',
                    ['id' => $this->getRequest()->getParam('history_id')]
                );
            }
        }

        return $this->resultRedirectFactory->create()->setPath('amasty_followup/*/');
    }
}
