<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Controller\Adminhtml\Queue;

use Amasty\Followup\Model\Indexer;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\AbstractResult;
use Magento\Framework\Exception\LocalizedException;

class RunQueue extends Action
{
    /**
     * @var Indexer
     */
    private $indexer;

    public function __construct(
        Context $context,
        Indexer $indexer
    ) {
        $this->indexer = $indexer;
        parent::__construct($context);
    }

    public function execute(): AbstractResult
    {
        try {
            $this->indexer->run();
            $this->messageManager->addSuccessMessage(__('Queue processing started'));
        } catch (LocalizedException $e) {
            $this->messageManager->addErrorMessage($e->getMessage());
        } catch (\Exception $e) {
            $this->messageManager->addExceptionMessage(
                $e,
                __('Error. Please see the log for more information.')
            );
        }

        return $this->resultRedirectFactory->create()->setPath('*/*/index');
    }
}
