<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */
namespace Amasty\Followup\Controller\Adminhtml\Blacklist;

use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;

class Save extends \Amasty\Followup\Controller\Adminhtml\Blacklist
{
    public function execute()
    {
        if ($this->getRequest()->getPostValue()) {
            $data = $this->getRequest()->getPostValue();

            try {
                $model = $this->_objectManager->create(\Amasty\Followup\Model\Blacklist::class);

                $id = $this->getRequest()->getParam('blacklist_id');

                if ($id) {
                    $model->load($id);
                    if ($id != $model->getId()) {
                        throw new LocalizedException(__('The wrong blacklist is specified.'));
                    }
                }

                $model->setData($data);

                $model->save();

                $this->messageManager->addSuccess(__('You saved the blacklist item.'));

                if ($this->getRequest()->getParam('back')) {
                    return $this->resultRedirectFactory->create()->setPath(
                        'amasty_followup/*/edit',
                        ['id' => $model->getId()]
                    );
                }

                return $this->resultRedirectFactory->create()->setPath('amasty_followup/*/');
            } catch (LocalizedException $e) {
                $this->messageManager->addError($e->getMessage());
                $id = (int)$this->getRequest()->getParam('blacklist_id');

                $resultRedirect = $this->resultRedirectFactory->create();
                if (!empty($id)) {
                    $resultRedirect->setPath('amasty_followup/*/edit', ['id' => $id]);
                } else {
                    $resultRedirect->setPath('amasty_followup/*/index');
                }

                return $resultRedirect;
            } catch (\Exception $e) {
                $this->messageManager->addError(
                    __('Something went wrong while saving the blacklist data. Please review the error log.')
                );
                $this->_objectManager->get(\Psr\Log\LoggerInterface::class)->critical($e);
                $this->_objectManager->get(\Magento\Backend\Model\Session::class)->setPageData($data);

                return $this->resultRedirectFactory->create()->setPath(
                    'amasty_followup/*/edit',
                    ['id' => $this->getRequest()->getParam('blacklist_id')]
                );
            }
        }

        return $this->resultRedirectFactory->create()->setPath('amasty_followup/*/');
    }
}
