<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */
namespace Amasty\Followup\Controller\Adminhtml\Blacklist;

class Edit extends \Amasty\Followup\Controller\Adminhtml\Blacklist
{
    /**
     * Customer edit action
     *
     * @SuppressWarnings(PHPMD.CyclomaticComplexity)
     * @SuppressWarnings(PHPMD.NPathComplexity)
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    public function execute()
    {
        $blacklistId = (int)$this->getRequest()->getParam('id');

        $blacklistData = [];

        $blacklist = $this->_objectManager->create(\Amasty\Followup\Model\Blacklist::class);
        $isExistingBlacklist = (bool)$blacklistId;

        if ($isExistingBlacklist) {
            $blacklist = $blacklist->load($blacklistId);

            if (!$blacklist->getId()) {
                $this->messageManager->addError(__('Something went wrong while editing the blacklist.'));
                $resultRedirect = $this->resultRedirectFactory->create();
                $resultRedirect->setPath('amasty_followup/*/index');

                return $resultRedirect;
            }
        }

        $this->initCurrentBlacklist($blacklist);

        $blacklistData['blacklist_id'] = $blacklistId;

        $this->_getSession()->setBlacklistData($blacklistData);

        $resultPage = $this->resultPageFactory->create();
        $resultPage->setActiveMenu('Amasty_Followup::followup_blacklist');
        $this->prepareDefaultCustomerTitle($resultPage);
        $resultPage->setActiveMenu('Amasty_Followup::followup');
        if ($isExistingBlacklist) {
            $resultPage->getConfig()->getTitle()->prepend($blacklist->getName());
        } else {
            $resultPage->getConfig()->getTitle()->prepend(__('New Blacklist Email'));
        }

        return $resultPage;
    }
}
