<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Controller\Adminhtml\Blacklist;

class Delete extends \Amasty\Followup\Controller\Adminhtml\Blacklist
{
    /**
     * Delete promo quote action
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('id');
        if ($id) {
            try {
                $model = $this->_objectManager->create(\Amasty\Followup\Model\Blacklist::class);
                $model->load($id);
                $model->delete();
                $this->messageManager->addSuccess(__('You deleted the blacklist.'));

                return $this->resultRedirectFactory->create()->setPath('amasty_followup/*/');
            } catch (\Magento\Framework\Exception\LocalizedException $e) {
                $this->messageManager->addError($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addError(
                    __('We can\'t delete the blacklist right now. Please review the log and try again.')
                );
                $this->_objectManager->get(\Psr\Log\LoggerInterface::class)->critical($e);

                return $this->resultRedirectFactory->create()->setPath(
                    'amasty_followup/*/edit',
                    ['id' => $this->getRequest()->getParam('id')]
                );
            }
        }
        $this->messageManager->addError(__('We can\'t find a blacklist to delete.'));

        return $this->resultRedirectFactory->create()->setPath('amasty_followup/*/');
    }
}
