<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Block\Email\Items;

use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;
use Magento\Wishlist\Model\Wishlist;

class WishlistStock extends Template
{
    /**
     * @var ObjectManagerInterface
     */
    protected $objectManager;

    public function __construct(
        Context $context,
        ObjectManagerInterface $objectManager,
        array $data = []
    ) {

        parent::__construct($context, $data);
        $this->objectManager = $objectManager;
    }

    public function getItems()
    {
        $wishlist = $this->objectManager
            ->create(Wishlist::class)
            ->loadByCustomerId($this->getCustomerId());

        return $wishlist->getItemCollection()
            ->setInStockFilter();
    }
}
