<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Block\Email\Items;

use Magento\Catalog\Model\Product;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;
use Magento\Wishlist\Model\Wishlist;

class WishlistSale extends Template
{
    /**
     * @var ObjectManagerInterface
     */
    protected $objectManager;

    public function __construct(
        Context $context,
        ObjectManagerInterface $objectManager,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->objectManager = $objectManager;
    }

    public function getItems()
    {
        $items = [];
        $wishlist = $this->objectManager
            ->create(Wishlist::class)
            ->loadByCustomerId($this->getCustomerId());

        $itemCollection = $wishlist->getItemCollection();

        foreach ($itemCollection as $item) {
            $product = $this->objectManager
                ->create(Product::class)
                ->load($item->getProductId());
            if ($product->getSpecialPrice()) {
                $items[] = $product;
            }
        }

        return $items;
    }
}
