<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Block\Email\Items;

use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;
use Magento\Wishlist\Model\ResourceModel\Item\Collection;
use Magento\Wishlist\Model\WishlistFactory;

class Wishlist extends Template
{
    /**
     * @var ObjectManagerInterface
     */
    protected $objectManager;

    /**
     * @var WishlistFactory
     */
    private $wishlistFactory;

    /**
     * Wishlist constructor.
     * @param Context $context
     * @param ObjectManagerInterface $objectManager
     * @param WishlistFactory $wishlistFactory
     * @param array $data
     */
    public function __construct(
        Context $context,
        ObjectManagerInterface $objectManager,
        WishlistFactory $wishlistFactory,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->objectManager = $objectManager;
        $this->wishlistFactory = $wishlistFactory;
    }

    public function getItems(): Collection
    {
        $wishlist = $this->wishlistFactory->create()->loadByCustomerId($this->getCustomerId());

        return $wishlist->getItemCollection();
    }
}
