<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Block\Email\Items;

use Magento\Framework\View\Element\Template;
use Magento\Quote\Api\CartRepositoryInterface;
use Magento\Quote\Model\Quote\Item;

class Upsell extends Template
{
    /**
     * @var CartRepositoryInterface
     */
    private $cartRepository;

    public function __construct(
        Template\Context $context,
        CartRepositoryInterface $cartRepository,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->cartRepository = $cartRepository;
    }

    /**
     * @return array
     */
    public function getItems()
    {
        $upSellProducts = [];
        $quote = $this->cartRepository->get((int)$this->getQuoteId());

        /** @var Item $item */
        foreach ($quote->getAllVisibleItems() as $item) {
            $product = $item->getProduct();
            //phpcs:ignore Magento2.Performance.ForeachArrayMerge.ForeachArrayMerge
            $upSellProducts = array_merge($upSellProducts, $product->getUpSellProducts());
        }

        return $upSellProducts;
    }
}
