<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Block\Email\Items;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\View\Element\Template;
use Magento\Quote\Api\CartRepositoryInterface;
use Magento\Quote\Api\Data\CartInterface;

class Quote extends Template
{
    /**
     * @var CartRepositoryInterface
     */
    private $cartRepository;

    public function __construct(
        Template\Context $context,
        CartRepositoryInterface $cartRepository,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->cartRepository = $cartRepository;
    }

    public function getItems(): array
    {
        return $this->getQuote() ? $this->getQuote()->getAllVisibleItems() : [];
    }

    public function getQuote(): ?CartInterface
    {
        try {
            return $this->cartRepository->get((int)$this->getQuoteId());
        } catch (NoSuchEntityException $e) {
            return null;
        }
    }
}
