<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Block\Email\Items;

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Catalog\Block\Product\Context;
use Magento\Catalog\Model\Product\LinkFactory;
use Magento\Catalog\Model\Product\Visibility;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory;
use Magento\CatalogInventory\Helper\Stock as StockHelper;
use Magento\Checkout\Block\Cart\Crosssell as CartCrosssell;
use Magento\Checkout\Model\Session;
use Magento\Quote\Model\Quote\Item\RelatedProducts;
use Magento\Quote\Api\CartRepositoryInterface;

class Crosssell extends CartCrosssell
{
    /**
     * @var CartRepositoryInterface
     */
    private $cartRepository;

    public function __construct(
        Context $context,
        Session $checkoutSession,
        Visibility $productVisibility,
        LinkFactory $productLinkFactory,
        RelatedProducts $itemRelationsList,
        StockHelper $stockHelper,
        CartRepositoryInterface $cartRepository,
        Quote $quote,
        array $data = [],
        ?CollectionFactory $productCollectionFactory = null,
        ?ProductRepositoryInterface $productRepository = null
    ) {
        parent::__construct(
            $context,
            $checkoutSession,
            $productVisibility,
            $productLinkFactory,
            $itemRelationsList,
            $stockHelper,
            $data,
            $productCollectionFactory,
            $productRepository
        );
        $this->cartRepository = $cartRepository;
    }

    public function getQuote()
    {
        return $this->cartRepository->get((int)$this->getQuoteId());
    }
}
