<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Block\Adminhtml\Settings;

use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;

class Blacklist extends Field
{
    /**
     * @var string
     */
    protected $_template = 'Amasty_Followup::upload.phtml';

    /**
     * @param AbstractElement $element
     * @return string
     */
    protected function _getElementHtml(AbstractElement $element): string
    {
        $this->setData('name', $element->getName());
        $this->setData('htmlId', $element->getHtmlId());

        return $this->toHtml();
    }

    public function getName(): string
    {
        return $this->getData('name');
    }

    public function getHtmlId(): string
    {
        return $this->getData('htmlId');
    }
}
