<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Block\Adminhtml\Rule\Edit\Tab;

use Amasty\Followup\Model\Rule\Locator;
use Amasty\Followup\Ui\DataProvider\Rule\Form;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Backend\Block\Widget\Form\Renderer\FieldsetFactory;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Magento\Framework\Data\FormFactory;
use Magento\Framework\Registry;
use Magento\Rule\Block\ConditionsFactory;
use Magento\Rule\Model\Condition\AbstractCondition;

class Conditions extends Generic implements TabInterface
{
    public const FIELDSET_ID = Form::FORM_NAMESPACE . '_conditions_fieldset';

    /**
     * @var string
     */
    protected $_nameInLayout = 'conditions';

    /**
     * @var FieldsetFactory
     */
    private $fieldsetFactory;

    /**
     * @var ConditionsFactory
     */
    private $conditionsFactory;

    /**
     * @var Locator
     */
    private $ruleLocator;

    public function __construct(
        Context $context,
        Registry $registry,
        FormFactory $formFactory,
        Locator $ruleLocator,
        ConditionsFactory $conditionsFactory,
        FieldsetFactory $fieldsetFactory,
        array $data = []
    ) {
        parent::__construct($context, $registry, $formFactory, $data);
        $this->ruleLocator = $ruleLocator;
        $this->fieldsetFactory = $fieldsetFactory;
        $this->conditionsFactory = $conditionsFactory;
    }

    public function getTabLabel()
    {
        return __('Conditions');
    }

    public function getTabTitle()
    {
        return __('Conditions');
    }

    public function canShowTab()
    {
        return true;
    }

    public function isHidden()
    {
        return false;
    }

    protected function _prepareForm()
    {
        $model = $this->ruleLocator->getRule();

        $form = $this->_formFactory->create()->setHtmlIdPrefix('rule_');

        $fieldset = $form->addFieldset(
            self::FIELDSET_ID,
            [
                'legend' => __('Apply the rule only if the following conditions are met (leave blank for all products)')
            ]
        )->setRenderer(
            $this->fieldsetFactory->create()
                ->setTemplate('Magento_CatalogRule::promo/fieldset.phtml')
                ->setFieldSetId(self::FIELDSET_ID)
                ->setNewChildUrl(
                    $this->getUrl(
                        '*/*/newConditionHtml',
                        [
                            'form' => self::FIELDSET_ID,
                            'form_namespace' => Form::FORM_NAMESPACE
                        ]
                    )
                )->setNameInLayout('amasty.followup.rule.fieldset.renderer')
        );

        $fieldset->addField(
            'conditions' . self::FIELDSET_ID,
            'text',
            [
                'name' => 'conditions' . self::FIELDSET_ID,
                'label' => __('Conditions'),
                'title' => __('Conditions'),
                'required' => true,
                'data-form-part' => Form::FORM_NAMESPACE
            ]
        )->setRule(
            $model->getSalesRule()
        )->setRenderer(
            $this->conditionsFactory->create()
        );

        $form
            ->setValues($this->ruleLocator->getRule()->getSalesRule()->getData())
            ->setNameInLayout('amasty.followup.rule.tab.conditions');
        $this->setForm($form);
        $this->setConditionFormName(
            $this->ruleLocator->getRule()->getSalesRule()->getConditions(),
            Form::FORM_NAMESPACE
        );

        return parent::_prepareForm();
    }

    private function setConditionFormName(AbstractCondition $abstractConditions, string $formName)
    {
        $abstractConditions->setFormName($formName);
        $abstractConditions->setJsFormObject(self::FIELDSET_ID);
        $conditions = $abstractConditions->getConditions();

        if ($conditions && is_array($conditions)) {
            foreach ($conditions as $condition) {
                $this->setConditionFormName($condition, $formName);
                $condition->setJsFormObject(self::FIELDSET_ID);
            }
        }
    }
}
