<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Block\Adminhtml\Rule\Edit\Button;

use Amasty\Followup\Model\Rule\Locator;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

class SaveAndContinue implements ButtonProviderInterface
{
    /**
     * @var Locator
     */
    private $ruleLocator;

    public function __construct(Locator $ruleLocator)
    {
        $this->ruleLocator = $ruleLocator;
    }

    public function getButtonData(): array
    {
        $ruleId = (bool)$this->ruleLocator->getRule()->getRuleId();

        return [
            'label' => $ruleId ? __('Save and Continue Edit') : __('Continue'),
            'class' => 'save' . ($ruleId ? '' : ' primary'),
            'data_attribute' => [
                'mage-init' => [
                    'button' => ['event' => 'saveAndContinueEdit'],
                ],
            ],
            'sort_order' => 40,
        ];
    }
}
