<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Block\Adminhtml\Rule\Edit\Button;

use Amasty\Followup\Model\Rule\Locator;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

class Save implements ButtonProviderInterface
{
    /**
     * @var Locator
     */
    private $ruleLocator;

    public function __construct(Locator $ruleLocator)
    {
        $this->ruleLocator = $ruleLocator;
    }

    public function getButtonData(): array
    {
        $button = [];
        if ($this->ruleLocator->getRule()->getRuleId()) {
            $button = [
                'label' => __('Save'),
                'class' => 'save primary',
                'data_attribute' => [
                    'mage-init' => [
                        'button' => [
                            'event' => 'save'
                        ]
                    ],
                    'form-role' => 'save',
                ],
                'sort_order' => 50,
            ];
        }

        return $button;
    }
}
