<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Api;

interface RuleRepositoryInterface
{
    /**
     * Retrieve rule by id.
     *
     * @param int $ruleId
     * @return \Amasty\Followup\Api\Data\RuleInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getById(int $ruleId): Data\RuleInterface;

    /**
     * Save rule.
     *
     * @param \Amasty\Followup\Api\Data\RuleInterface $rule
     * @return \Amasty\Followup\Api\Data\RuleInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function save(Data\RuleInterface $rule): Data\RuleInterface;

    /**
     * Delete rule.
     *
     * @param \Amasty\Followup\Api\Data\RuleInterface $rule
     * @return bool true on success
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function delete(Data\RuleInterface $rule): bool;

    /**
     * Delete rule by ID.
     *
     * @param int $ruleId
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function deleteById(int $ruleId): bool;

    /**
     * Retrieve rules matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \Amasty\Followup\Api\Data\RuleSearchResultsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
    ): Data\RuleSearchResultsInterface;
}
