<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Api\Data;

use Magento\Framework\Api\SearchResultsInterface;

interface RuleSearchResultsInterface extends SearchResultsInterface
{
    /**
     * Get rule list.
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface[]
     */
    public function getItems();

    /**
     * Set rule list.
     *
     * @param \Amasty\Followup\Api\Data\RuleInterface[] $items
     * @return $this
     */
    public function setItems(array $items);
}
