<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Api\Data;

interface RuleInterface
{
    public const RULE_ID = 'rule_id';
    public const START_EVENT_TYPE = 'start_event_type';
    public const CANCEL_EVENT_TYPE = 'cancel_event_type';
    public const NAME = 'name';
    public const IS_ACTIVE = 'is_active';
    public const TO_SUBSCRIBERS = 'to_subscribers';
    public const SENDER_NAME = 'sender_name';
    public const SENDER_EMAIL = 'sender_email';
    public const SENDER_CC = 'sender_cc';
    public const UTM_SOURCE = 'utm_source';
    public const UTM_MEDIUM = 'utm_medium';
    public const UTM_TERM = 'utm_term';
    public const UTM_CONTENT = 'utm_content';
    public const UTM_CAMPAIGN = 'utm_campaign';
    public const CONDITIONS_SERIALIZED = 'conditions_serialized';
    public const CUSTOMER_DATE_EVENT = 'customer_date_event';
    public const CUSTOMER_GROUP_IDS = 'customer_group_ids';
    public const SEGMENT_IDS = 'segment_ids';
    public const STORE_IDS = 'store_ids';

    /**
     * @return int
     */
    public function getRuleId(): int;

    /**
     * @param int $id
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setRuleId(int $id): RuleInterface;

    /**
     * @return string
     */
    public function getStartEventType(): string;

    /**
     * @param string $type
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setStartEventType(string $type): RuleInterface;

    /**
     * @return string
     */
    public function getCancelEventType(): string;

    /**
     * @param string $type
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setCancelEventType(string $type): RuleInterface;

    /**
     * @return string
     */
    public function getName(): string;

    /**
     * @param string $name
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setName(string $name): RuleInterface;

    /**
     * @return bool
     */
    public function isActive(): bool;

    /**
     * @param bool $status
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setIsActive(bool $status): RuleInterface;

    /**
     * @return bool
     */
    public function isToSubscribers(): bool;

    /**
     * @param bool $status
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setIsToSubscribers(bool $status): RuleInterface;

    /**
     * @return string
     */
    public function getSenderName(): string;

    /**
     * @param string $name
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setSenderName(string $name): RuleInterface;

    /**
     * @return string
     */
    public function getSenderEmail(): string;

    /**
     * @param string $email
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setSenderEmail(string $email): RuleInterface;

    /**
     * @return string
     */
    public function getSenderCc(): string;

    /**
     * @param string $senderCc
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setSenderCc(string $senderCc): RuleInterface;

    /**
     * @return string
     */
    public function getUtmSource(): string;

    /**
     * @param string $utmSource
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setUtmSource(string $utmSource): RuleInterface;

    /**
     * @return string
     */
    public function getUtmMedium(): string;

    /**
     * @param string $utmMedium
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setUtmMedium(string $utmMedium): RuleInterface;

    /**
     * @return string
     */
    public function getUtmTerm(): string;

    /**
     * @param string $utmTerm
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setUtmTerm(string $utmTerm): RuleInterface;

    /**
     * @return string
     */
    public function getUtmContent(): string;

    /**
     * @param string $utmContent
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setUtmContent(string $utmContent): RuleInterface;

    /**
     * @return string
     */
    public function getUtmCampaign(): string;

    /**
     * @param string $utmCampaign
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setUtmCampaign(string $utmCampaign): RuleInterface;

    /**
     * @return string|null
     */
    public function getConditionsSerialized(): ?string;

    /**
     * @param string $conditionsSerialized
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setConditionsSerialized(string $conditionsSerialized): RuleInterface;

    /**
     * @return string
     */
    public function getDateEvent(): string;

    /**
     * @param string $dateEvent
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setDateEvent(string $dateEvent): RuleInterface;

    /**
     * @return array|null
     */
    public function getCustomerGroupIds(): ?array;

    /**
     * @param array|null $customerGroupIds
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setCustomerGroupIds(?array $customerGroupIds): RuleInterface;

    /**
     * @return array|null
     */
    public function getSegmentIds(): ?array;

    /**
     * @param array|null $segmentIds
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setSegmentIds(?array $segmentIds): RuleInterface;

    /**
     * @return array|null
     */
    public function getStoreIds(): ?array;

    /**
     * @param array|null $storeIds
     *
     * @return \Amasty\Followup\Api\Data\RuleInterface
     */
    public function setStoreIds(?array $storeIds): RuleInterface;
}
