<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Duplicate Categories for Magento 2
*/

declare(strict_types=1);

namespace Amasty\DuplicateCategories\Controller\Adminhtml\DuplicateCategory;

use Amasty\DuplicateCategories\Model\CategoriesSave;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;

class Save extends Action
{
    /**
     * @var CategoriesSave
     */
    protected $model;

    public function __construct(
        Context $context,
        CategoriesSave $model
    ) {
        $this->model = $model;
        parent::__construct($context);
    }

    public function execute()
    {
        $fromCategoryId = (int)$this->getRequest()->getParam('id');
        $toParentId = (int)$this->getRequest()->getParam('parent_category_id');

        if (!$toParentId) {
            $toParentId = $fromCategoryId;
        }

        $toCategoryId = $this->model->duplicateCategory($fromCategoryId, $toParentId);

        $this->model->handleSubcategories($fromCategoryId, $toCategoryId);

        return $this->resultRedirectFactory->create()->setPath(
            'catalog/category/index',
            [
                '_current' => true,
                'id' => $toCategoryId
            ]
        );
    }

    protected function isAllowed()
    {
        return $this->_authorization->isAllowed('Magento_Catalog::categories');
    }
}
